/*
 * dma.c
 *
 *  Created on: Jun 24, 2019
 *      Author: a0222913
 */
#include <stdint.h>
#include <msp430.h>
#include <TLC6983DMA.h>
#include "delayTimer.h"

unsigned int dmaSyncFlag;
unsigned int firstTransfer = TRUE;
#define CHECK_FIRST 1


void dmaInitial() //DMA0 -> Tx, DMA1 -> Rx
{
    DMACTL0 = DMA1TSEL_18+DMA0TSEL_19;        // DMA0 - UCB0TXIFG
                                               // DMA1 - UCB0RXIFG
     // Setup DMA0
     __data20_write_long((uintptr_t) &DMA0SA,(uintptr_t) dmaTxData);
                                               // Source block address
     __data20_write_long((uintptr_t) &DMA0DA,(uintptr_t) &UCB0TXBUF);
                                               // Destination single address

     DMA0CTL |= DMASRCINCR_3 + DMASBDB + DMALEVEL;  // increase source address, source byte to destination byte, level sensitive

     // Setup DMA1
     __data20_write_long((uintptr_t) &DMA1SA,(uintptr_t) &UCB0RXBUF);
                                               // Source single address
     __data20_write_long((uintptr_t) &DMA1DA,(uintptr_t) dmaRxData);
                                               // Destination block address

                                                    // Destination block address
     DMA1CTL |= DMADSTINCR_3 + DMASBDB + DMALEVEL;//;  // increase destination address, source byte to destination byte, level sensitive*/
}

void manualSyncDma()
{
    dmaSyncFlag=0;
    uint8_t i = 0;
    uint8_t max_loop = 0;
    while(TA2R != 0)
    {
        for(i = 0; i < max_loop; i++){
            __no_operation();
        }
        max_loop++;
    }
}

uint8_t firstDMA = 1;
void dmaTransfer(unsigned int dmaTxSize, unsigned int dmaRxSize, unsigned int checkResponse)
{
#ifdef CHECK_FIRST
    if(firstTransfer == FALSE){
        if(checkResponse==TRUE)
        {
            DMA1CTL |= DMAEN; //enable Rx DMA
            while(!(DMA1CTL&DMAIFG)); //Wait until receive all response byte
            DMA1CTL &= ~(DMAEN + DMAIFG); //disable DMA1
            DMA0CTL &= ~(DMAEN + DMAIFG);//disable DMA0
        }
        else
        {
            while(!(DMA0CTL&DMAIFG)); //Wait until send all command bytes
            DMA0CTL &= ~(DMAEN + DMAIFG);//disable DMA0
        }
    }
    else
        firstTransfer = FALSE;
#endif
    DMA0SZ = dmaTxSize;
    DMA1SZ = dmaRxSize;

    manualSyncDma();
    DMA0CTL |= DMAEN; //enable Tx DMA

#ifndef CHECK_FIRST
    if(checkResponse==TRUE)
    {
        DMA1CTL |= DMAEN; //enable Rx DMA
        while(!(DMA1CTL&DMAIFG)); //Wait until receive all response byte
        DMA1CTL &= ~(DMAEN + DMAIFG); //disable DMA1
        DMA0CTL &= ~(DMAEN + DMAIFG);//disable DMA0
    }
    else
    {
        while(!(DMA0CTL&DMAIFG)); //Wait until send all command bytes
        DMA0CTL &= ~(DMAEN + DMAIFG);//disable DMA0
    }
#endif
}


#pragma vector = TIMER2_A1_VECTOR
//Interrupt in 2.5MHz
__interrupt void Timer2_A(void)
{
    /*if(g_Count_Timer > 0){
        --g_Count_Timer;
    }*/
    dmaSyncFlag = 1;
    TA2CCTL1 &= ~CCIE; //Disable interrupt
    TA2CCTL1 &= ~CCIFG; //Clear flag

//    P1OUT |= BIT0; //Only for test use
}
